import { call, put, takeEvery } from "redux-saga/effects";

import { getDashboardFailure, getDashboardSuccess } from "../dashboardSlice";
import { getDashboardAPI } from "../dashboardAPI";

function fakeAPI() {
  return new Promise((resolve, reject) => {
    setTimeout(() => {
      resolve({
        waitingForCorrelation: 6,
        waitingForCharge: 1524086,
        waitingForFeedback: 11839,
        negativeFeedback: 0,
      });
    }, 3000);
  });
}

function* workDashboardFetch() {
  try {
    const data = yield call(() => fakeAPI());
    // const { data } = yield call(() => getDashboardAPI());
    yield put(getDashboardSuccess(data));
  } catch (e) {
    yield put(getDashboardFailure(e));
  }
}

export default function* dashboardSaga() {
  yield takeEvery("dashboard/getDashboardFetch", workDashboardFetch);
}
