import { useNavigate } from "react-router-dom";
import {
  Accordion,
  AccordionActions,
  AccordionDetails,
  AccordionSummary,
  Button,
  Grid,
  Stack,
  Typography,
} from "@mui/material";
import ExpandMoreIcon from "@mui/icons-material/ExpandMore";
import moment from "moment";

const RecentAlerts = ({ alerts = [] }) => {
  const navigate = useNavigate();

  return (
    <Grid
      item
      container
      xs={12}
      spacing={1}
      direction={"column"}
      sx={{
        mt: 2,
        mb: 4,
      }}
    >
      <Grid
        item
        container
        sx={{ display: "flex", justifyContent: "space-between" }}
      >
        <Grid item>
          <Typography variant="h6">Alerts</Typography>
        </Grid>
      </Grid>

      {alerts?.map((alertItem, index) => (
        <Grid item key={index}>
          <Accordion>
            <AccordionSummary
              expandIcon={<ExpandMoreIcon />}
              aria-controls="panel3-content"
              id="panel3-header"
            >
              <Typography variant="title3">{alertItem.alertMessage}</Typography>
            </AccordionSummary>
            <AccordionDetails>
              <Grid container>
                <Grid item xs={4}>
                  <Stack direction="column" spacing={2}>
                    <Typography variant="smallText1">Generated Date</Typography>
                    <Typography variant="caption">
                      {moment(alertItem?.generationDate).format("MM-DD-YYYY")}
                    </Typography>
                  </Stack>
                </Grid>
                <Grid item xs={4}>
                  <Stack direction="column" spacing={2}>
                    <Typography variant="smallText1">Generated Time</Typography>
                    <Typography variant="caption">
                      {moment(alertItem?.generationDate).calendar()}
                    </Typography>
                  </Stack>
                </Grid>
              </Grid>
            </AccordionDetails>
            <AccordionActions>
              <Button
                onClick={() => {
                  navigate(`/alerts/${alertItem?.alertType}`);
                }}
              >
                Details
              </Button>
            </AccordionActions>
          </Accordion>
        </Grid>
      ))}
    </Grid>
  );
};

export default RecentAlerts;
