import { createSlice } from "@reduxjs/toolkit";

import { ERROR, INITIAL, LOADED, LOADING } from "../../helpers/constants";

export const alertsSlice = createSlice({
  name: "alerts",
  initialState: {
    storeState: INITIAL,
    alerts: [],
    generatedQuery: ``,
    generatedQueryState: INITIAL,
    executeQueryState: INITIAL,
  },
  reducers: {
    getAlertsFetch: (state) => {
      state.storeState = LOADING;
    },
    getAlertsSuccess: (state, action) => {
      state.alerts = action.payload;
      state.storeState = LOADED;
    },
    getAlertsFailure: (state) => {
      state.storeState = ERROR;
    },

    getQueryFetch: (state) => {
      state.generatedQueryState = LOADING;
    },
    getQuerySuccess: (state, action) => {
      state.generatedQuery = action.payload;
      state.generatedQueryState = LOADED;
    },
    getQueryFailure: (state) => {
      state.generatedQueryState = ERROR;
    },

    executeQueryFetch: (state) => {
      state.executeQueryState = LOADING;
    },
    executeQuerySuccess: (state) => {
      state.executeQueryState = LOADED;
    },
    executeQueryFailure: (state) => {
      state.executeQueryState = ERROR;
    },
  },
});

export const {
  getAlertsFetch,
  getAlertsSuccess,
  getAlertsFailure,
  getQueryFetch,
  getQuerySuccess,
  getQueryFailure,
  executeQueryFetch,
  executeQuerySuccess,
  executeQueryFailure,
} = alertsSlice.actions;

export default alertsSlice.reducer;
