import React from "react";
import { Modal as MUIModal, styled } from "@mui/material";

const StyledModal = styled((props) => (
  <MUIModal disableAutoFocus {...props} style={{ outline: 0 }} />
))(({ theme }) => ({
  display: "flex",
  alignItems: "center",
  justifyContent: "center",
  outline: "none",
  ":focus-visible": { outline: "none" },
}));

export default function Modal({ open = false, children = <></>, ...props }) {
  return (
    <StyledModal open={open} disableEscapeKeyDown aria-modal="true" {...props}>
      {children}
    </StyledModal>
  );
}
