import { createTheme } from "@mui/material";

import palette from "./palette";
import { createResponsiveTypography } from "./typography";

let theme = createTheme({
  components: {
    MuiButtonBase: {
      styleOverrides: {
        root: {
          userSelect: "text",
        },
      },
    },

    MuiCssBaseline: {
      styleOverrides: (themeParam) => ({
        "&::-webkit-scrollbar": {
          backgroundColor: "#transparent",
          borderRadius: "10px",
          width: "7px",
          height: "7px",
        },
        "&::-webkit-scrollbar-track": {
          backgroundColor: "#E6E6E6",
          borderRadius: "10px",
          width: "7px",
        },
        "&::-webkit-scrollbar-thumb": {
          backgroundColor: "#B3B9C8",
          borderRadius: "10px",
          width: "7px",
        },
      }),
    },
  },
  overrides: {
    // Style sheet name
    MuiTouchRipple: {
      // Name of the rule
      child: {
        // Some CSS
        backgroundColor: "green",
      },
    },
  },
  palette,

  // spacing: 4
});

theme = createResponsiveTypography(theme);

export default theme;
