import { useDispatch, useSelector } from "react-redux";

import { getDashboardFetch } from "./dashboardSlice";
import { INITIAL, ERROR } from "../../helpers/constants";

const useDashboard = () => {
  const dispatch = useDispatch();

  const { storeState: dashboardState, dashboard } = useSelector(
    (state) => state.dashboard
  );

  const fetchDashboard = () => {
    if (dashboardState === INITIAL || dashboardState === ERROR) {
      dispatch(getDashboardFetch());
    }
  };

  return {
    fetchDashboard,
    dashboard,
    dashboardState
  };
};

export default useDashboard;
