import { useEffect } from "react";
import { Grid } from "@mui/material";

import Cards from "./Cards";
import MainLayout from "../../components/MainLayout";
import RecentAlerts from "./RecentAlerts";
import useDashboard from "./useDashboard";
import useAlerts from "../alerts/useAlerts";
import { LOADING } from "../../helpers/constants";
import SkeletonWrapper from "../../components/SkeletonWrapper";

export default function Dashboard() {
  const { fetchDashboard, dashboard } = useDashboard();
  const { fetchAlerts, alerts, alertsState } = useAlerts();

  useEffect(() => {
    fetchDashboard();
    fetchAlerts();
  }, []);
  console.log("Hello -> ")
  console.log(alerts)
  const CardsView = () => (
    <Grid item container xs={12}>
      <Grid item xs={12}>
        <Cards data={dashboard} />
      </Grid>
      <Grid item xs={12}>
        <SkeletonWrapper loading={alertsState === LOADING} list>
          <RecentAlerts alerts={alerts} />
        </SkeletonWrapper>
      </Grid>
    </Grid>
  );
  return (
    <MainLayout>
      <CardsView />
    </MainLayout>
  );
}
