import { useDispatch, useSelector } from "react-redux";

import {
  executeQueryFetch,
  getAlertsFetch,
  getQueryFetch,
} from "./alertsSlice";
import { INITIAL, ERROR } from "../../helpers/constants";
import { verifyRoleAPI } from "./alertsAPI";
import { showToastBanner } from "../toastBanner/toastBannerSlice";

const useAlerts = () => {
  const dispatch = useDispatch();

  const {
    alertsState,
    generatedQueryState,
    executeQueryState,
    alerts,
    generatedQuery,
  } = useSelector((state) => state.alerts);

  const fetchAlerts = () => {
    console.log(1)
    // if (alertsState === INITIAL || alertsState === ERROR) {
      console.log(2)
      dispatch(getAlertsFetch());
    // }
  };

  const fetchQuery = () => {
    dispatch(getQueryFetch());
  };

  const executeQuery = async () => {
    const response = await verifyRole();
    if (response.isAllowed) dispatch(executeQueryFetch());
  };

  const verifyRole = async (data) => {
    const payload = {
      data,
    };
    const response = await verifyRoleAPI(payload);
    console.log(response.isAllowed);
    if (!response.isAllowed) {
      console.log("e");
      dispatch(
        showToastBanner({
          message: "Sorry, You are not allowed to execute queries",
          type: "error",
        })
      );
    }
    return response.isAllowed;
  };
  return {
    fetchAlerts,
    fetchQuery,
    verifyRole,
    executeQuery,
    alerts,
    alertsState,
    generatedQueryState,
    executeQueryState,
    generatedQuery,
  };
};

export default useAlerts;
