import { call, put, takeEvery } from "redux-saga/effects";

import { getQuerySuccess, getQueryFailure } from "../alertsSlice";
import { showToastBanner } from "../../toastBanner/toastBannerSlice";

function fakeAPI() {
  return new Promise((resolve, reject) => {
    setTimeout(() => {
      resolve(`CREATE TABLE employees (
        id INT PRIMARY KEY,
        first_name VARCHAR(50),
        last_name VARCHAR(50),
        email VARCHAR(100),
        age INT
    );
    
    INSERT INTO employees (id, first_name, last_name, email, age) VALUES
    (1, 'John', 'Doe', 'john.doe@example.com', 30),
    (2, 'Jane', 'Smith', 'jane.smith@example.com', 25),
    (3, 'Alice', 'Johnson', 'alice.johnson@example.com', 28),
    (4, 'Robert', 'Brown', 'robert.brown@example.com', 45),
    (5, 'Emily', 'Davis', 'emily.davis@example.com', 32),
    (6, 'Michael', 'Miller', 'michael.miller@example.com', 35),
    (7, 'Jessica', 'Wilson', 'jessica.wilson@example.com', 29),
    (8, 'David', 'Moore', 'david.moore@example.com', 40),
    (9, 'Sarah', 'Taylor', 'sarah.taylor@example.com', 26),
    (10, 'Chris', 'Anderson', 'chris.anderson@example.com', 38),
    (11, 'Laura', 'Thomas', 'laura.thomas@example.com', 27),
    (12, 'James', 'Jackson', 'james.jackson@example.com', 31),
    (13, 'Karen', 'White', 'karen.white@example.com', 33),
    (14, 'Daniel', 'Harris', 'daniel.harris@example.com', 34),
    (15, 'Sophia', 'Martin', 'sophia.martin@example.com', 37);
    `);
    }, 4000);
  });
}

function* workQueryFetch() {
  try {
    const data = yield call(() => fakeAPI());
    // const { data } = yield call(() => getAlertsAPI());
    yield put(getQuerySuccess(data));
  } catch (e) {
    yield put(getQueryFailure(e));
    yield put(
      showToastBanner({
        message:
          "Sorry, we were unable to load your account profile. Please try again later.",
        type: "error",
      })
    );
  }
}

export default function* querySaga() {
  yield takeEvery("alerts/getQueryFetch", workQueryFetch);
}
