import { call, put, takeEvery } from "redux-saga/effects";

import { getAlertsFailure, getAlertsSuccess } from "../alertsSlice";
import { getAlertsAPI } from "../alertsAPI";

function fakeAPI() {
  return new Promise((resolve, reject) => {
    setTimeout(() => {
      resolve([
        {
          id: 1,
          alertMessage:
            "6 Transaction(s) waiting for correlation for more than 20 hours. [3-0]",
          generationDate: "2024-07-29T04:21:34.125Z",
          alertType: "correlation",
        },
        {
          id: 2,
          alertMessage:
            "11839 Transaction(s) waiting for CBO feedback for more than 20 hours. [10-1]",
          generationDate: "2024-07-29T04:21:34.125Z",
          alertType: "feedback",
        },
        {
          id: 3,
          alertMessage:
            "1524086 Transaction(s) waiting for charge for more than 20 hours. [5-0]",
          generationDate: "2024-07-29T04:21:34.125Z",
          alertType: "charge",
        },
      ]);
    }, 4000);
  });
}

function* workAlertsFetch() {
  try {
    console.log("alerts saga")
    const data = yield call(() => fakeAPI());
    // const { data } = yield call(() => getAlertsAPI());
    console.log("alerts are -> ");
    console.log(data);
    yield put(getAlertsSuccess(data));
  } catch (e) {
    yield put(getAlertsFailure(e));
  }
}

export default function* alertsSaga() {
  yield takeEvery("alerts/getAlertsFetch", workAlertsFetch);
}
