import { call, put, takeEvery } from "redux-saga/effects";

import { getQuerySuccess, getQueryFailure } from "../alertsSlice";
import { showToastBanner } from "../../toastBanner/toastBannerSlice";

function fakeAPI() {
  return new Promise((resolve, reject) => {
    setTimeout(() => {
      resolve("Query was executed successfully");
    }, 4000);
  });
}

function* workExecuteQueryFetch() {
  try {
    const data = yield call(() => fakeAPI());
    // const { data } = yield call(() => getAlertsAPI());
    yield put(getQuerySuccess(data));
  } catch (e) {
    yield put(getQueryFailure(e));
    yield put(
      showToastBanner({
        message:
          "Sorry, we were unable to load your account profile. Please try again later.",
        type: "error",
      })
    );
  }
}

export default function* querySaga() {
  yield takeEvery("alerts/executeQueryFetch", workExecuteQueryFetch);
}
