import * as React from "react";
import { DataGrid } from "@mui/x-data-grid";
import { Box, Pagination, Paper } from "@mui/material";
import Button from "../../components/Button";

const columns = [
  { field: "id", headerName: "ID", width: 70 },
  { field: "title", headerName: "Transaction Id", width: 130 },
  { field: "status", headerName: "Status", width: 130 },
];

const rows = [
  { id: 1, lastName: "Snow", firstName: "Jon", age: 35 },
  { id: 2, lastName: "Lannister", firstName: "Cersei", age: 42 },
  { id: 3, lastName: "Lannister", firstName: "Jaime", age: 45 },
  { id: 4, lastName: "Stark", firstName: "Arya", age: 16 },
  { id: 5, lastName: "Targaryen", firstName: "Daenerys", age: null },
  { id: 6, lastName: "Melisandre", firstName: null, age: 150 },
  { id: 7, lastName: "Clifford", firstName: "Ferrara", age: 44 },
  { id: 8, lastName: "Frances", firstName: "Rossini", age: 36 },
  { id: 9, lastName: "Roxie", firstName: "Harvey", age: 65 },
];

export default function TransactionsTable({ transactions }) {
  const getTableRows = () =>
    transactions.map((transaction) => ({
      id: transaction.id,
      title: transaction.title,
      status: transaction.status,
    }));

    const CustomFooter = () => (
      <Box display="flex" justifyContent="space-between" alignItems="center" p={2}>
        <div>
          {/* You can use pagination controls here if needed */}
          <Pagination count={10} color="primary" />
        </div>
        <Button variant="contained" color="primary">Custom Button</Button>
      </Box>
    );

  return (
    <Paper
      xs={12}
      sx={{
        display: "flex",
        height: 400,
        justifyContent: "center",
        background: "white",
        borderRadius: 2,
        width: "100%",
        p: 2,
      }}
    >
      <DataGrid
        rows={getTableRows()}
        columns={columns}
        initialState={{
          pagination: {
            paginationModel: { page: 0, pageSize: 5 },
          },
        }}
        pageSizeOptions={[5, 10]}
        checkboxSelection
        components={{
          Footer: CustomFooter,
        }}
      />
    </Paper>
  );
}
