import { useState } from "react";

import { Grid, Paper, Stack, Typography } from "@mui/material";
import moment from "moment";
import { useFormik } from "formik";

import MainLayout from "../../components/MainLayout";
import TextField from "../../components/TextField";
import TextareaAutosize from "../../components/TextArea";
import ExecuteQueryWarningModal from "./ExecuteQueryWarningModal";
import { SchemaValidation } from "../../schemas/QueryValidationSchema";
import useAlerts from "./useAlerts";
import { CSVLink } from "react-csv";
import { LOADING } from "../../helpers/constants";
import Button from "../../components/Button";
import TransactionsTable from "./TransactionsTable";

import MyTable from "./table2";
const headers = [
  { label: "", key: "title" },
  { label: "", key: "value" },
];

export default function Alerts() {
  const [showWarningModal, setShowWarningModal] = useState(false);
  const { fetchQuery, generatedQuery, executeQuery,generatedQueryState,
    executeQueryState } = useAlerts();

  const handleSubmit = (formValue) => {
    console.log("form value is = ", formValue);
  };

  const alertDetails = {
    title:
      "6 Transaction(s) waiting for correlation for more than 20 hours. [3-0]",
    generatedDate: "2024-07-29T04:21:34.125Z",
    application: "OBO",
    actualTransactionCount: 6,
    transactionToBeQueried: 6,
    user: "",
    incidentNo: "",
  };

  const transactions = [
    {
      id:1,
      title: "HEllo there",
      status: "10-3"
    },
    {
      id:1,
      title: "HEllo there",
      status: "10-3"
    },
    {
      id:1,
      title: "HEllo there",
      status: "10-3"
    }
  ];

  const formik = useFormik({
    initialValues: {
      userName: alertDetails.user,
      incNumber: alertDetails.incidentNo,
    },
    validationSchema: SchemaValidation,
    validateOnChange: true,
    validateOnBlur: false,
    validateOnMount: true,
    onSubmit: handleSubmit,
  });

  const commonProps = (field, label, required = true) => ({
    fullWidth: false,
    error: formik.touched[field] && Boolean(formik.errors[field]),
    hasValidationIcon: formik.touched[field],
    helperText: formik.touched[field] && formik.errors[field],
    label: label,
    required: required,
    ...formik.getFieldProps(field),
  });

  const handleWarningModalClose = () => {
    setShowWarningModal(false);
  };

  const generateQuery = () => {
    fetchQuery();
  };

  const handleExecuteQuery = async () => {
    setShowWarningModal(true);
  };

  const getCSVData = () => [
    { title: "Title", value: alertDetails.title },
    { title: "Generated Date", value: alertDetails.generatedDate },
    { title: "Application", value: alertDetails.application },
    {
      title: "Actual Transaction Count",
      value: alertDetails.actualTransactionCount,
    },
    {
      title: "Transaction To Be Queried",
      value: alertDetails.transactionToBeQueried,
    },
    { title: "User", value: formik.values.userName },
    { title: "Incident No", value: formik.values.incNumber },
  ];

  const downloadSQLFile = (content = generatedQuery, filename = "generated_query.sql") => {
    console.log(content)
    const blob = new Blob([content], { type: 'text/sql' });
    const url = window.URL.createObjectURL(blob);
    const a = document.createElement('a');
    a.href = url;
    a.download = filename;
    document.body.appendChild(a);
    a.click();
    document.body.removeChild(a);
    window.URL.revokeObjectURL(url);
  };

  const AlertDetails = () => (
    <Paper
      xs={12}
      sx={{
        display: "flex",
        justifyContent: "center",
        background: "white",
        borderRadius: 2,
        width: "100%",
        height: "fit-content",
        p: 2,
      }}
    >
      <Grid item container direction={"column"} spacing={2}>
        <Grid item mb={2}>
          <Typography variant="title2">{alertDetails.title}</Typography>
        </Grid>
        <Grid item container>
          <Grid item xs={3.5}>
            <Typography variant="body2" color="text.darkGrey">
              Generated Date
            </Typography>
          </Grid>
          <Grid item xs={4}>
            <Typography variant="body1">
              {moment(alertDetails.generatedDate).format("MM/DD/YYYY")} -{" "}
              {moment(alertDetails.generatedDate).calendar()}
            </Typography>
          </Grid>
        </Grid>
        <Grid item container>
          <Grid item xs={3.5}>
            <Typography variant="body2" color="text.darkGrey">
              Application
            </Typography>
          </Grid>
          <Grid item xs={4}>
            <Typography variant="body1">{alertDetails.application}</Typography>
          </Grid>
        </Grid>
        <Grid item container>
          <Grid item xs={3.5}>
            <Typography variant="body2" color="text.darkGrey">
              Actual Transaction Count
            </Typography>
          </Grid>
          <Grid item xs={4}>
            <Typography variant="body1">
              {alertDetails.actualTransactionCount}
            </Typography>
          </Grid>
        </Grid>
        <Grid item container>
          <Grid item xs={3.5}>
            <Typography variant="body2" color="text.darkGrey">
              User
            </Typography>
          </Grid>
          <Grid item xs={8.5} md={4}>
            <TextField xs={12} {...commonProps("userName", "")} />
          </Grid>
        </Grid>
        <Grid item container>
          <Grid item xs={3.5}>
            <Typography variant="body2" color="text.darkGrey">
              Incident No
            </Typography>
          </Grid>
          <Grid item xs={8.5} md={4}>
            <TextField xs={12} {...commonProps("incNumber", "")} />
          </Grid>
        </Grid>
        <Grid item container justifyContent={"end"} spacing={2}>
          <Grid item>
            <Button
              variant="contained"
              color="primary"
              disabled={!formik.isValid}
            >
              Update Query
            </Button>
          </Grid>
          <Grid item>
            <CSVLink data={getCSVData()} headers={headers}>
              <Button variant="contained">Export Transactions</Button>
            </CSVLink>
          </Grid>
          <Grid item>
            <Button
              variant="contained"
              color="primary"
              onClick={generateQuery}
              disabled={!formik.isValid}
              loading={generatedQueryState === LOADING}
            >
              Generate Query
            </Button>
          </Grid>
        </Grid>
      </Grid>
    </Paper>
  );

  const GeneratedQuery = () => (
    <Paper
      xs={12}
      sx={{
        display: "flex",
        justifyContent: "center",
        background: "white",
        borderRadius: 2,
        width: "100%",
        height: "fit-content",
        p: 2,
      }}
    >
      <Grid item container direction={"column"} spacing={2}>
        <Grid item mb={2}>
          <Typography variant="title2">Generated Query</Typography>
        </Grid>
        <Grid item>
          <TextareaAutosize minRows={15} disabled value={generatedQuery} />
        </Grid>
        <Grid item>
          <Stack direction="row" spacing={2}>
            <Button variant="contained" onClick={() => downloadSQLFile()}>Download SQL File</Button>
            <Button variant="outlined" onClick={handleExecuteQuery} 
              loading={executeQueryState === LOADING}
              >
              Execute Query
            </Button>
          </Stack>
        </Grid>
      </Grid>
    </Paper>
  );
  return (
    <MainLayout>
      <Grid item container m={1}>
        {AlertDetails()}
      </Grid>
      <Grid item container m={1}>
        <TransactionsTable transactions={transactions}/>
        {/* <MyTable transactions={transactions}/> */}
      </Grid>
      <Grid item container m={1}>
        <GeneratedQuery />
      </Grid>

      <ExecuteQueryWarningModal
        show={showWarningModal}
        onClose={handleWarningModalClose}
        onClick={executeQuery}
      />
    </MainLayout>
  );
}
