import {
  Box,
  Divider,
  Drawer,
  easing,
  IconButton,
  List,
  ListItem,
  ListItemButton,
  ListItemIcon,
  ListItemText,
  styled,
  Toolbar,
  Typography,
  useMediaQuery,
  useTheme,
} from "@mui/material";
import MuiAppBar from "@mui/material/AppBar";
import React, { useState } from "react";
import { useNavigate } from "react-router-dom";
import MenuIcon from "@mui/icons-material/Menu";
import { ChevronLeft, ChevronRight } from "@mui/icons-material";
import DashboardIcon from "@mui/icons-material/Dashboard";
import AddAlertIcon from "@mui/icons-material/AddAlert";

const drawerWidth = 240;

const Main = styled("main", {
  shouldForwardProp: (prop) => prop !== "open" && prop !== "isBrowser",
})(({ theme, open, isBrowser }) => ({
  flexGrow: 1,
  padding: theme.spacing(3),
  transition: theme.transitions.create("margin", {
    easing: theme.transitions.easing.sharp,
    duration: theme.transitions.duration.leavingScreen,
  }),
  marginLeft: `-${drawerWidth}px`,
  ...(open &&
    isBrowser && {
      transition: theme.transitions.create("margin", {
        easing: theme.transitions.easing.easeOut,
        duration: theme.transitions.duration.enteringScreen,
      }),
      marginLeft: 0,
    }),
}));

const AppBar = styled(MuiAppBar, {
  shouldForwardProp: (prop) => prop !== "open" && prop !== "isBrowser",
})(({ theme, open, isBrowser }) => ({
  transition: theme.transitions.create(["margin", "width"], {
    easing: theme.transitions.easing.sharp,
    duration: theme.transitions.duration.leavingScreen,
  }),
  ...(open && {
    // width: `calc(100% - ${drawerWidth}px)`,
    marginLeft: `${drawerWidth}px`,
    transition: theme.transitions.create(["margin", "width"], {
      easing: theme.transitions.easing.easeOut,
      duration: theme.transitions.duration.enteringScreen,
    }),
  }),
}));

const DrawerHeader = styled("div")(({ theme }) => ({
  display: "flex",
  alignItems: "center",
  // padding: theme.spacing(0, 1),
  ...theme.mixins.toolbar,
  justifyContent: "flex-end",
}));

const createMenuItems = (logout) => {
  return [
    {
      label: "Dashboard",
      icon: <DashboardIcon />,
      value: "/dashboard",
    },
    // {
    //   label: "Alerts",
    //   icon: <AddAlertIcon />,
    //   value: "/alerts",
    // },
  ];
};
export default function MenuDrawer({ header }) {
  const theme = useTheme();
  const isBrowser = useMediaQuery(theme.breakpoints.up("md"));
  const [open, setOpen] = useState(isBrowser ? true : false);
  const navigate = useNavigate();
  const MENU_ITEMS = createMenuItems();
  const handleDrawerOpen = () => {
    setOpen(true);
  };
  const handleDrawerClose = () => {
    if (!isBrowser) setOpen(false);
  };

  return (
    <Box sx={{ display: "flex", height: "auto" }}>
      <AppBar
        position="fixed"
        open={open}
        sx={{ zIndex: (theme) => (isBrowser ? theme.zIndex.drawer + 1 : 0) }}
      >
        <Toolbar>
          <IconButton
            color="inherit"
            aria-label="open drawer"
            onClick={handleDrawerOpen}
            edge="start"
            sx={{
              mr: 2,
              ...(open && { display: "none" }),
            }}
          >
            <MenuIcon />
          </IconButton>
          <Typography variant="h6" noWrap component="div">
            {header ?? "OBO Alert Application"}
          </Typography>
        </Toolbar>
      </AppBar>
      <Drawer
        sx={{
          width: drawerWidth,
          flexShrink: 0,
          "& .MuiDrawer-paper": {
            width: drawerWidth,
            boxSizing: "border-box",
          },
        }}
        docked={"true"}
        variant={isBrowser ? "persistent" : "temporary"}
        anchor="left"
        open={open}
      >
        <DrawerHeader>
          <IconButton onClick={handleDrawerClose}>
            {!isBrowser &&
              (theme.direction === "ltr" ? <ChevronLeft /> : <ChevronRight />)}
          </IconButton>
        </DrawerHeader>
        <List>
          {MENU_ITEMS.map((item, index) => (
            <React.Fragment key={index}>
              <ListItem
                key={index}
                disablePadding
                onClick={() => {
                  navigate(item.value);
                }}
              >
                <ListItemButton>
                  <ListItemIcon>{item.icon}</ListItemIcon>
                  <ListItemText primary={item.label} />
                </ListItemButton>
              </ListItem>
            </React.Fragment>
          ))}
          <Divider />
        </List>
      </Drawer>
      {/* <Main open={open} isBrowser={isBrowser}>
        <DrawerHeader />
      </Main> */}
    </Box>
  );
}
