import { Box, Grid } from "@mui/material";
import MenuDrawer from "./MenuDrawer";
import { Children } from "react";

const MainLayout = ({ children, header }) => {
  return (
    <Box
      sx={{
        display: "flex",
        width: "100vw",
        height: "100vh",
        backgroundColor: "background.default",
        overflowX: "hidden",
      }}
    >
      <Grid item>
        <MenuDrawer header={header} />
      </Grid>
      <Grid
        item
        container
        xs={12}
        sx={{
          padding: 2,
          mt: 8,
        }}
      >
        <Grid
          item
          container
          sx={{
            display: "flex",
            justifyContent: "center",
          }}
        >
          {children}
        </Grid>
      </Grid>
    </Box>
  );
};

export default MainLayout;
