import { createSlice } from "@reduxjs/toolkit";

import {
  ERROR,
  INITIAL,
  LOADED,
  LOADING,
} from "../../helpers/constants";

export const dashboardSlice = createSlice({
  name: "dashboard",
  initialState: {
    storeState: INITIAL,
    dashboard: {},
  },
  reducers: {
    getDashboardFetch: (state) => {
      state.storeState = LOADING;
    },
    getDashboardSuccess: (state, action) => {
      state.dashboard = action.payload;
      state.storeState = LOADED;
    },
    getDashboardFailure: (state) => {
      state.storeState = ERROR;
    },
  },
});

export const { getDashboardFetch, getDashboardSuccess, getDashboardFailure } =
  dashboardSlice.actions;

export default dashboardSlice.reducer;
