import {
  Grid,
  Paper,
  Typography,
  useMediaQuery,
  useTheme,
} from "@mui/material";
// import  from "@mui/icons-material/AddBox";
import AddBoxIcon from "@mui/icons-material/AddBoxOutlined";
import AccountBalanceIcon from "@mui/icons-material/AccountBalanceOutlined";
import AddReactionIcon from "@mui/icons-material/AddReactionOutlined";
import AdminPanelSettingsIcon from "@mui/icons-material/AdminPanelSettingsOutlined";

import SkeletonWrapper from "../../components/SkeletonWrapper";
import useDashboard from "./useDashboard";
import { LOADING } from "../../helpers/constants";

const Card = ({ cardData }) => {
  const theme = useTheme();
  const isBrowser = useMediaQuery(theme.breakpoints.up("md"));
  const { dashboardState } = useDashboard();

  return (
    <Paper
      sx={{
        px: 3,
        py: 2,
        mb: 2,
        flex: 1,
        elevation: 2,
        display: "flex",
        borderRadius: "10px",
        flexDirection: "column",
        minWidth: { xs: "100%", md: 170, lg: 200 },
        backgroundColor: cardData.color,
      }}
    >
      <Grid item container columnSpacing={1} flexDirection={"column"}>
        <SkeletonWrapper loading={dashboardState === LOADING}>
          <Grid item xs={2}>
            {cardData.icon}
          </Grid>
          <Grid item container xs={5} md={12} flexDirection={"column"}>
            <Grid item>
              <Typography variant="h4" color="text.data">
                {cardData.data}
              </Typography>
            </Grid>
            <Grid item>
              <Typography variant="title3" color="text.tertiary">
                {cardData.title}
              </Typography>
            </Grid>
          </Grid>
        </SkeletonWrapper>
      </Grid>
    </Paper>
  );
};

const Cards = ({ data }) => {
  const theme = useTheme();
  const isBrowser = useMediaQuery(theme.breakpoints.up("md"));
  const cardData = [
    {
      title: "Coorelation",
      icon: <AddBoxIcon sx={{ color: "#2984ff" }} fontSize="large" />,
      data: data?.waitingForCorrelation || 0,
      color: "#FFEBF0",
    },
    {
      title: "Charging",
      icon: <AccountBalanceIcon sx={{ color: "#2984ff" }} fontSize="large" />,
      data: data?.waitingForCharge || 0,
      color: "#FFF0D3",
    },
    {
      title: "Feedback",
      icon: <AddReactionIcon sx={{ color: "#2984ff" }} fontSize="large" />,
      data: data?.waitingForFeedback || 0,
      color: "#C9FBE2",
    },
    {
      title: "Negative Feedback",
      icon: (
        <AdminPanelSettingsIcon sx={{ color: "#2984ff" }} fontSize="large" />
      ),
      data: data?.negativeFeedback || 0,
      color: "#D1E9FF",
    },
  ];

  return (
    <Grid
      item
      container
      xs={12}
      // spacing={1}
      direction={isBrowser ? "row" : "column"}
      wrap="nowrap"
      sx={{
        minHeight: "130px",
        display: "flex",
        justifyContent: "space-between",
      }}
    >
      {cardData.map((card, index) => (
        <Grid item key={index}>
          <Card key={index} cardData={card} />
        </Grid>
      ))}
    </Grid>
  );
};

export default Cards;
