import { Grid, Stack, Typography } from "@mui/material";
import WarningRoundedIcon from "@mui/icons-material/WarningRounded";

import Modal from "../../components/Modal";
import Button from "../../components/Button";

const ExecuteQueryWarningModal = ({
  show = false,
  onClose = () => {},
  onClick,
}) => {
  return (
    <Modal open={show} onClose={onClose}>
      <Grid
        container
        sx={{
          p: 2.5,
          borderRadius: 1.25,
          backgroundColor: "#FFFFFF",
          width: { xs: "70%", sm: "320px" },
          maxWidth: { xs: "70%", sm: "320px" },
          heigh: "auto",
          maxHeight: "90%",
          overflowY: "auto",
        }}
      >
        <Grid item xs={12}>
          <Stack alignItems="center" justifyContent="center">
            <WarningRoundedIcon
              sx={{
                backgroundPosition: "center",
                height: "102px",
                width: "152px",
                color: "#ffab00",
                borderRadius: "5px",
              }}
            />
            <Stack direction="column">
              <Typography variant="title2" sx={{ mt: 1 }}>
                Are you sure you want
              </Typography>
              <Typography alignSelf="center" variant="title2">
                to execute this query?
              </Typography>
            </Stack>
          </Stack>
        </Grid>

        <Grid
          item
          container
          spacing={2}
          sx={{
            mt: 2,
            flexWrap: { xs: "nowrap", md: "wrap" },
            flexDirection: { xs: "column-reverse", md: "row" },
          }}
        >
          <Grid item xs={12} md={6}>
            <Button variant="outlined" onClick={onClose} fullWidth>
              Cancel
            </Button>
          </Grid>

          <Grid item xs={12} md={6}>
            <Button
              fullWidth
              onClick={() => {
                onClick();
                onClose();
              }}
              variant="contained"
            >
              Execute
            </Button>
          </Grid>
        </Grid>
      </Grid>
    </Modal>
  );
};

export default ExecuteQueryWarningModal;
