import { Button as MUIButton, CircularProgress, styled } from "@mui/material";

const Button = 
    ({
      children,
      loading,
      loaderColor = "white",
      loaderSize = 20,
      buttonRef,
      ...props
    }) => (
      <>
        <MUIButton variant="contained" ref={buttonRef} {...props}>
          {loading ? (
            <CircularProgress sx={{ color: loaderColor }} size={loaderSize} />
          ) : (
            children
          )}
        </MUIButton>
      </>
    )
export default Button