
import { CssBaseline } from "@mui/material";
import {
  createBrowserRouter,
  createRoutesFromElements,
  RouterProvider,
} from "react-router-dom";

import Routes from "./routes/Routes";
import ToastBanner from "./features/toastBanner/ToastBanner";

const App = () => {

  const router = createBrowserRouter(createRoutesFromElements(Routes()));
  return (
    <>
      <CssBaseline />
      <RouterProvider router={router} />
      <ToastBanner />
    </>
  );
};

export default App;
