<%@ include file="./init.jsp" %>

<%
    User editUser = null;
    long userId = ParamUtil.getLong(renderRequest, "userId");
    
    if ( userId > 0) {
        editUser = UserLocalServiceUtil.fetchUser(userId);
    }
    
    String headerText = editUser == null? 
            "Edit User" : "Edit User: " +  editUser.getScreenName();
            
    
%>


<portlet:renderURL var="userManagementURL">
    <portlet:param name="mvcPath" value="/view.jsp" />
</portlet:renderURL>

<portlet:actionURL name="updateUserAction" var="updateUserActionURL"></portlet:actionURL>

<liferay-ui:success key="success" message="User updated successfully."/>

<div class="sheet sheet-lg" style="padding:60px;">
	<div class="sheet-header">
		<h2 class="sheet-title">Set Temporary Password</h2>
	</div>
	<div class="sheet-section" style="margin: 0px;">
		<div class="form-group">
		<h3 class="sheet-subtitle">User Data</h3>
			<form class="" method="POST" action="<%= updateUserActionURL %>">
				<% if (editUser != null) { %>
				<div class="row">
					<div class="col-md-12">
						<div class="form-group input-String-wrapper">
							<label class="control-label" for="screenName">Username: </label> <input
								class="field form-control lfr-input-text" id="screenName"
								name="screenName" style=""
								value="<%= editUser.getScreenName() %>" type="text"
								maxlength="75" disabled>
						</div>
						<input type="hidden" name='<portlet:namespace/>userId'
							value="<%= editUser.getUserId()%>">
						<div class="form-group input-String-wrapper">
							<label class="control-label">Email Address:</label> <input
								type="text" class="field form-control lfr-input-text"
								value="<%= editUser.getEmailAddress() %>"
								name="emailAddress" disabled>
						</div>
						
						<div class="form-group input-String-wrapper">
							<label class="control-label">Set a new temporary
								password:</label> <input
								type="text" class="field form-control lfr-input-text"
								name ='<portlet:namespace/>temporaryPassword' placeholder=""
								>
						</div>

						<div class="pull-right" style="margin: auto 0px 0px auto;">
							<a id="tmpPasswordBack" href="<%= userManagementURL %>" class="btn btn-default">Back</a>
							<button id="updatePassword" type="submit" class="btn  btn-primary btn-default">Update Password</button>
						</div>
					</div>
				</div>
		</div>
		</form>
		<% } else { %>
		<p>
			No user found with the specified ID. Please head <a
				href="<%= userManagementURL %>">back.</a>
		</p>
		<%} %>

	</div>
</div>
</div>
    
    
    
    
    
    
    
</div>