<%@ include file="./init.jsp" %>
<%@ page import="com.liferay.portal.kernel.util.PropsUtil"%>

<portlet:renderURL var="searchURL">
    <portlet:param name="mvcPath" value="/view.jsp"></portlet:param>
    <portlet:param name="search" value="/view.jsp"></portlet:param>
</portlet:renderURL>

<%
    //Get the user name from the search form submission
    String search = ParamUtil.getString(renderRequest, "searchParam").trim();
    List<User> searchResults = new LinkedList<User>();
    User userByScreenname = null;
	
    if (Validator.isNotNull(search)) {
		if(Validator.isEmailAddress(search)){
    		userByScreenname = UserLocalServiceUtil.fetchUserByEmailAddress(themeDisplay.getCompanyId(), search);
    	}else{
    		userByScreenname = UserLocalServiceUtil.fetchUserByScreenName(themeDisplay.getCompanyId(), search);
    	}
        if (userByScreenname != null) {
            searchResults.add(userByScreenname);
        }
    }
    User currentUser =  themeDisplay.getUser();
    String ga4Id = PropsUtil.get("ga4.id");
    
%>

<script>
    var portletUserManagementView = true;
    var ga4Id = "<%= ga4Id %>";
</script>

<div class="container">
    
    <div class="row search col-xs-12 - col-md-8 col-lg-6">
	    <form action="#" class="form-inline search-users-form" method="POST" id="<portlet:namespace/>searchForm" enctype="multipart/form-data">
	        <input type="text" placeholder="Search users" name="<portlet:namespace />searchParam">
	        <button type="submit" class="btn btn-primary">Search</button>
	    </form>
    </div>
    <div class="row results col-xs-12">
        <table class="table">
                    <tr>
                        <th>#</th>
                        <th>Screenname</th>
                        <th>Email</th>
                        <th>First Name</th>
                        <th>Last Name</th>
                        <th></th>
                        <%if (renderRequest.isUserInRole("Customer Management Role") || renderRequest.isUserInRole("Administrator")){ %>
                        <th></th>
                        <th></th>
                        <%} %>
                        <%if (renderRequest.isUserInRole("Administrator")){ %>
                        <th></th>
                        <%} %>
                    </tr>
        
        <% if (Validator.isNotNull(search)) { %>
            <h3>Displaying results for: <%= search %></h3>
            <% if (searchResults.size() > 0) { %>			
                    <% for (User u : searchResults) { %>
                    <!--  Creates the USER edit page url -->
                    <portlet:renderURL var="editUserURL">
                        <portlet:param name="mvcPath" value="/edit-user.jsp" />
                        <portlet:param name="userId"
                            value="<%=String.valueOf(u.getUserId())%>" />
                    </portlet:renderURL>
                    <portlet:renderURL var="releaseEmailURL">
                        <portlet:param name="mvcPath" value="/release-email.jsp" />
                        <portlet:param name="userId"
                            value="<%=String.valueOf(u.getUserId())%>" />
                    </portlet:renderURL>
                    <portlet:renderURL var="updateUserURL">
                        <portlet:param name="mvcPath" value="/update-username.jsp" />
                        <portlet:param name="userId"
                            value="<%=String.valueOf(u.getUserId())%>" />
                    </portlet:renderURL>
                    <tr>
                        <td><%= u.getUserId() %></td>
                        <td><%= u.getScreenName() %></td>
                        <td><%= u.getEmailAddress() %></td>
                        <td><%= u.getFirstName() %></td>
                        <td><%= u.getLastName() %></td>
                        <td><a id="changePassword" class="" href="<%= editUserURL %>">Change Password</a></td>
                        <td><a id="releaseEmail" class="" href="<%= releaseEmailURL %>">Release Email</a></td>
                        <%if (renderRequest.isUserInRole("Update Username Role") || renderRequest.isUserInRole("Administrator")){ %>
                        	<td><a id="updateUsername" class="" href="<%= updateUserURL %>">Update Username</a></td>
                        <%} %>
                        <%if (renderRequest.isUserInRole("Administrator")){ %>
                            <td><a id="goToUser" href="/group/control_panel/manage?p_p_id=com_liferay_users_admin_web_portlet_UsersAdminPortlet&p_p_lifecycle=0&p_p_state=maximized&p_p_mode=view&_com_liferay_users_admin_web_portlet_UsersAdminPortlet_mvcRenderCommandName=%2Fusers_admin%2Fedit_user&_com_liferay_users_admin_web_portlet_UsersAdminPortlet_p_u_i_d=<%=u.getUserId() %>" class="">Go to Users</a></td>	
                        <%} %>
                    </tr>
                    <%} %>
            <% } else { %>
                <tr>
                    <td>No users found.</td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <%if (renderRequest.isUserInRole("Customer Management Role") || renderRequest.isUserInRole("Administrator") ){ %>
                    	<td></td>
                        <td></td>
                    <%} %>
                    <%if (renderRequest.isUserInRole("Administrator")){ %>
                        <td></td>
                    <%} %>    
                </tr>
            <% } %>
        <% } else { %>
            <tr>
                <td>Search users by screenname or email.</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <%if (renderRequest.isUserInRole("Customer Management Role") || renderRequest.isUserInRole("Administrator") ){ %>
                    <td></td>
                    <td></td>
                <%} %>
                <%if (renderRequest.isUserInRole("Administrator")){ %>
                    <td></td>
                <%} %>
            </tr>
        <% } %>
        </table>
    </div>
    
</div>


<div id="searchbarie" class="d-none"> 
    <!-- This is needed for IE. For some reason, the control panel menu does not open/close without the search portlet :) -->
    <liferay-portlet:runtime portletName="com_liferay_portal_search_web_portlet_SearchPortlet" />
</div>

<script type="text/javascript">
    var portletNamespace = "<portlet:namespace/>";
    var portletBaseURL = "<%= PortletURLFactoryUtil.create(request, themeDisplay.getPortletDisplay().getId(), themeDisplay.getPlid(), PortletRequest.RENDER_PHASE) %>";
             
</script>