/*
 * Decompiled with CFR 0.152.
 */
package com.accenture.jamaica.usermanagment.portlet;

import com.accenture.acms.commons.logging.ExecutionTimerWrapper;
import com.accenture.jamaica.entities.account.Contact;
import com.accenture.jamaica.entities.account.IPassAccount;
import com.accenture.jamaica.entities.account.ReturnTypeAccountMaintenance;
import com.accenture.jamaica.entities.account.UserAccountBP;
import com.accenture.jamaica.entities.wsconf.WsConfiguration;
import com.accenture.jamaica.sb.integration.service.GetAccountInfoClientLocalServiceUtil;
import com.accenture.jamaica.sb.integration.service.UpdateAccountClientLocalServiceUtil;
import com.accenture.jamaica.utils.db.account.AccountDB;
import com.accenture.jamaica.utils.db.wsconf.WsConfDB;
import com.accenture.jamaica.utils.security.validators.InputValidationException;
import com.accenture.jamaica.utils.security.validators.SecurityUtils;
import com.accenture.jamaica.utils.strings.StringUtils;
import com.accenture.jamaica.ws.service.account.RfcZGETACCOUNTINFOException;
import com.accenture.jamaica.ws.service.accountmaintainance.RfcZTPCONTACTSException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet;
import com.liferay.portal.kernel.security.auth.AuthTokenUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.xml.datatype.DatatypeConfigurationException;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"com.liferay.portlet.display-category=category.hidden", "com.liferay.portlet.header-portlet-css=/css/main.css", "com.liferay.portlet.footer-portlet-javascript=/js/userManagement.js", "com.liferay.portlet.css-class-wrapper=user-managment-wrapper", "com.liferay.portlet.instanceable=false", "javax.portlet.init-param.template-path=/", "javax.portlet.portlet-mode=text/html;view,edit", "javax.portlet.init-param.view-template=/view.jsp", "javax.portlet.name=com_accenture_jamaica_userManagment_UserManagmentPortlet", "javax.portlet.display-name=User Management", "javax.portlet.resource-bundle=content.Language", "javax.portlet.security-role-ref=administrator"}, service={Portlet.class})
public class UserManagmentPortlet
extends MVCPortlet {
    private static final Log LOGGER = LogFactoryUtil.getLog(UserManagmentPortlet.class);
    private static final WsConfDB wsConfDb = new WsConfDB();
    private static final String LOG_USERMANAGEMENT_UPDATE = "UsermanagementUpdate";

    public void render(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        super.render(renderRequest, renderResponse);
    }

    public void updateUserAction(ActionRequest request, ActionResponse response) {
        long userId = ParamUtil.getLong((PortletRequest)request, (String)"userId");
        try {
            if (userId <= 0L) {
                throw new PortalException();
            }
            String newPassword = ParamUtil.getString((PortletRequest)request, (String)"temporaryPassword");
            response.getRenderParameters().setValue("mvcPath", "/edit-user.jsp");
            response.getRenderParameters().setValue("userId", String.valueOf(userId));
            if (Validator.isNotNull((String)newPassword)) {
                UserLocalServiceUtil.updatePassword((long)userId, (String)newPassword, (String)newPassword, (boolean)true, (boolean)true);
                SessionMessages.add((PortletRequest)request, (String)"success");
            } else {
                SessionErrors.add((PortletRequest)request, (String)"userPasswordError");
            }
        }
        catch (PortalException e) {
            if (LOGGER.isErrorEnabled()) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                LOGGER.error((Object)"User Not Found!");
                LOGGER.trace((Object)("Details: " + sw), (Throwable)e);
            }
            SessionErrors.add((PortletRequest)request, (String)"userNotFoundError");
            response.getRenderParameters().setValue("mvcPath", "/edit-user.jsp");
        }
        catch (SystemException e) {
            if (LOGGER.isErrorEnabled()) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                LOGGER.error((Object)"system Error getting user!");
                LOGGER.trace((Object)("Details: " + sw), (Throwable)e);
            }
            SessionErrors.add((PortletRequest)request, (String)"systemError");
            response.getRenderParameters().setValue("mvcPath", "/edit-user.jsp");
        }
    }

    public void releaseEmailAction(ActionRequest request, ActionResponse response) {
        ExecutionTimerWrapper etw = new ExecutionTimerWrapper(UUID.randomUUID().toString(), ((Object)((Object)this)).getClass());
        etw.startTimer("Global");
        long userId = ParamUtil.getLong((PortletRequest)request, (String)"userId");
        try {
            if (userId <= 0L) {
                throw new PortalException();
            }
            response.getRenderParameters().setValue("mvcPath", "/release-email.jsp");
            response.getRenderParameters().setValue("userId", String.valueOf(userId));
            User existingUser = UserLocalServiceUtil.fetchUserById((long)userId);
            AccountDB accountDb = new AccountDB();
            UserAccountBP userBP = null;
            IPassAccount ipassAccountRef = null;
            String oldEmailAddress = existingUser.getEmailAddress();
            if (existingUser != null) {
                userBP = accountDb.getBpEntryForUser(existingUser.getScreenName(), etw);
                if (userBP != null) {
                    WsConfiguration wsConf = wsConfDb.getWsConfList("getAccountInfo", etw);
                    ipassAccountRef = GetAccountInfoClientLocalServiceUtil.getAccountInfo((UserAccountBP)userBP, (Date)new Date(0L), (String)existingUser.getScreenName(), (String)"getAccountInformation", (String)wsConf.getWsEndpoint(), (String)wsConf.getWsUser(), (String)wsConf.getWsPwd(), (ExecutionTimerWrapper)etw);
                    IPassAccount ipassAccount = new IPassAccount(ipassAccountRef);
                    if (ipassAccount.getiPassAccountStatus().getAccountStatusCode().equalsIgnoreCase("E0005")) {
                        String currentTimestamp = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
                        existingUser.setEmailAddress(existingUser.getEmailAddress() + "_" + currentTimestamp);
                        existingUser.setScreenName(existingUser.getScreenName() + "_" + currentTimestamp);
                        UserLocalServiceUtil.updateUser((User)existingUser);
                        LOGGER.info((Object)("The email has been released and updated to " + existingUser.getEmailAddress()));
                        this.updateAccountContact(ipassAccount, existingUser, oldEmailAddress);
                    } else {
                        SessionErrors.add((PortletRequest)request, (String)"userPasswordError");
                        response.getRenderParameters().setValue("mvcPath", "/release-email.jsp");
                    }
                } else {
                    String currentTimestamp = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
                    existingUser.setEmailAddress(existingUser.getEmailAddress() + "_" + currentTimestamp);
                    existingUser.setScreenName(existingUser.getScreenName() + "_" + currentTimestamp);
                    UserLocalServiceUtil.updateUser((User)existingUser);
                }
                SessionMessages.add((PortletRequest)request, (String)"success");
            }
        }
        catch (PortalException e) {
            if (LOGGER.isErrorEnabled()) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                LOGGER.error((Object)"User Not Found!");
                LOGGER.trace((Object)("Details: " + sw), (Throwable)e);
            }
            SessionErrors.add((PortletRequest)request, (String)"userNotFoundError");
            response.getRenderParameters().setValue("mvcPath", "/release-email.jsp");
        }
        catch (SystemException e) {
            if (LOGGER.isErrorEnabled()) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                LOGGER.error((Object)"system Error getting user!");
                LOGGER.trace((Object)("Details: " + sw), (Throwable)e);
            }
            SessionErrors.add((PortletRequest)request, (String)"systemError");
            response.getRenderParameters().setValue("mvcPath", "/release-email.jsp");
        }
        catch (RfcZGETACCOUNTINFOException | DatatypeConfigurationException e) {
            e.printStackTrace();
            if (LOGGER.isErrorEnabled()) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                LOGGER.error((Object)"system Error getting account info service!");
                LOGGER.trace((Object)("Details: " + sw), e);
            }
            SessionErrors.add((PortletRequest)request, (String)"systemError");
            response.getRenderParameters().setValue("mvcPath", "/release-email.jsp");
        }
        catch (RfcZTPCONTACTSException e) {
            e.printStackTrace();
            e.printStackTrace();
            if (LOGGER.isErrorEnabled()) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                LOGGER.error((Object)"system Error update contact service!");
                LOGGER.trace((Object)("Details: " + sw), (Throwable)e);
            }
            SessionErrors.add((PortletRequest)request, (String)"systemError");
            response.getRenderParameters().setValue("mvcPath", "/release-email.jsp");
        }
        catch (Exception e) {
            e.printStackTrace();
            e.printStackTrace();
            if (LOGGER.isErrorEnabled()) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                LOGGER.error((Object)"Exception!");
                LOGGER.trace((Object)("Details: " + sw), (Throwable)e);
            }
            SessionErrors.add((PortletRequest)request, (String)"systemError");
            response.getRenderParameters().setValue("mvcPath", "/release-email.jsp");
        }
    }

    public void updateUserNameAction(ActionRequest request, ActionResponse response) {
        ExecutionTimerWrapper etw = new ExecutionTimerWrapper(UUID.randomUUID().toString(), ((Object)((Object)this)).getClass());
        etw.startTimer("Global");
        long userId = ParamUtil.getLong((PortletRequest)request, (String)"userId");
        try {
            if (userId <= 0L) {
                throw new PortalException();
            }
            String newUserName = ParamUtil.getString((PortletRequest)request, (String)"newUserName");
            response.getRenderParameters().setValue("mvcPath", "/update-username.jsp");
            response.getRenderParameters().setValue("userId", String.valueOf(userId));
            if (Validator.isNotNull((String)newUserName)) {
                User existingUser = UserLocalServiceUtil.fetchUserById((long)userId);
                LOGGER.info((Object)"after fetch user");
                AccountDB accountDb = new AccountDB();
                UserAccountBP userBP = null;
                IPassAccount ipassAccountRef = null;
                String oldUsername = existingUser.getScreenName();
                String oldEmailAddress = existingUser.getEmailAddress();
                if (existingUser != null) {
                    userBP = accountDb.getBpEntryForUser(existingUser.getScreenName(), etw);
                    if (userBP != null) {
                        WsConfiguration wsConf = wsConfDb.getWsConfList("getAccountInfo", etw);
                        ipassAccountRef = GetAccountInfoClientLocalServiceUtil.getAccountInfo((UserAccountBP)userBP, (Date)new Date(0L), (String)existingUser.getScreenName(), (String)"getAccountInformation", (String)wsConf.getWsEndpoint(), (String)wsConf.getWsUser(), (String)wsConf.getWsPwd(), (ExecutionTimerWrapper)etw);
                        IPassAccount ipassAccount = new IPassAccount(ipassAccountRef);
                        if (!ipassAccount.getiPassAccountStatus().getAccountStatusCode().equalsIgnoreCase("E0005")) {
                            existingUser.setScreenName(newUserName);
                            UserLocalServiceUtil.updateUser((User)existingUser);
                            LOGGER.info((Object)("The username has been updated to " + existingUser.getScreenName()));
                            accountDb.insertUserBpRelation(newUserName, userId, ipassAccount.getAccountExtId(), etw);
                            accountDb.removeUserBpRelation(oldUsername, ipassAccount.getAccountExtId(), etw);
                            this.updateAccountContact(ipassAccount, existingUser, oldEmailAddress);
                        } else {
                            SessionErrors.add((PortletRequest)request, (String)"userPasswordError");
                            response.getRenderParameters().setValue("mvcPath", "/update-username.jsp");
                        }
                    } else {
                        existingUser.setScreenName(newUserName);
                        UserLocalServiceUtil.updateUser((User)existingUser);
                        LOGGER.info((Object)("The username has been updated to " + existingUser.getScreenName()));
                    }
                    SessionMessages.add((PortletRequest)request, (String)"success");
                }
            } else {
                SessionErrors.add((PortletRequest)request, (String)"userPasswordError");
                response.getRenderParameters().setValue("mvcPath", "/update-username.jsp");
            }
        }
        catch (PortalException e) {
            if (LOGGER.isErrorEnabled()) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                LOGGER.error((Object)"User Not Found!");
                LOGGER.trace((Object)("Details: " + sw), (Throwable)e);
            }
            SessionErrors.add((PortletRequest)request, (String)"userNotFoundError");
            response.getRenderParameters().setValue("mvcPath", "/update-username.jsp");
        }
        catch (SystemException e) {
            if (LOGGER.isErrorEnabled()) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                LOGGER.error((Object)"system Error getting user!");
                LOGGER.trace((Object)("Details: " + sw), (Throwable)e);
            }
            SessionErrors.add((PortletRequest)request, (String)"systemError");
            response.getRenderParameters().setValue("mvcPath", "/update-username.jsp");
        }
        catch (RfcZGETACCOUNTINFOException | DatatypeConfigurationException e) {
            e.printStackTrace();
            if (LOGGER.isErrorEnabled()) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                LOGGER.error((Object)"system Error getting account info service!");
                LOGGER.trace((Object)("Details: " + sw), e);
            }
            SessionErrors.add((PortletRequest)request, (String)"systemError");
            response.getRenderParameters().setValue("mvcPath", "/update-username.jsp");
        }
        catch (RfcZTPCONTACTSException e) {
            e.printStackTrace();
            if (LOGGER.isErrorEnabled()) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                LOGGER.error((Object)"system Error update contact service!");
                LOGGER.trace((Object)("Details: " + sw), (Throwable)e);
            }
            SessionErrors.add((PortletRequest)request, (String)"systemError");
            response.getRenderParameters().setValue("mvcPath", "/update-username.jsp");
        }
        catch (Exception e) {
            e.printStackTrace();
            e.printStackTrace();
            if (LOGGER.isErrorEnabled()) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                LOGGER.error((Object)"Exception!");
                LOGGER.trace((Object)("Details: " + sw), (Throwable)e);
            }
            SessionErrors.add((PortletRequest)request, (String)"systemError");
            response.getRenderParameters().setValue("mvcPath", "/update-username.jsp");
        }
    }

    private void updateAccountContact(IPassAccount account, User userObj, String oldEmail) throws RfcZTPCONTACTSException {
        ExecutionTimerWrapper etw = new ExecutionTimerWrapper(UUID.randomUUID().toString(), ((Object)((Object)this)).getClass());
        etw.startTimer("Global");
        WsConfDB wsConfDb = new WsConfDB();
        WsConfiguration wsConfOCM = wsConfDb.getWsConfList("orderContractMaintain", etw);
        ReturnTypeAccountMaintenance contactList = UpdateAccountClientLocalServiceUtil.fetchContact((String)account.getAccountExtId(), (String)userObj.getScreenName(), (String)LOG_USERMANAGEMENT_UPDATE, (String)wsConfOCM.getWsEndpoint(), (String)wsConfOCM.getWsUser(), (String)wsConfOCM.getWsPwd(), (ExecutionTimerWrapper)etw);
        for (Contact c : contactList.getContactList()) {
            if (!oldEmail.equalsIgnoreCase(c.getEmailAddress()) || !userObj.getFirstName().equals(c.getFirstName()) || !userObj.getLastName().equals(c.getLastName())) continue;
            UpdateAccountClientLocalServiceUtil.removeContact((String)account.getAccountExtId(), (Contact)c, (String)account.getUserName(), (String)LOG_USERMANAGEMENT_UPDATE, (String)wsConfOCM.getWsEndpoint(), (String)wsConfOCM.getWsUser(), (String)wsConfOCM.getWsPwd(), (ExecutionTimerWrapper)etw);
            contactList = UpdateAccountClientLocalServiceUtil.fetchContact((String)account.getAccountExtId(), (String)userObj.getScreenName(), (String)LOG_USERMANAGEMENT_UPDATE, (String)wsConfOCM.getWsEndpoint(), (String)wsConfOCM.getWsUser(), (String)wsConfOCM.getWsPwd(), (ExecutionTimerWrapper)etw);
            break;
        }
        ReturnTypeAccountMaintenance res = UpdateAccountClientLocalServiceUtil.createContact((String)account.getAccountExtId(), (String)userObj.getFirstName(), (String)userObj.getLastName(), (String)userObj.getScreenName(), (String)userObj.getEmailAddress(), (String)account.getUserName(), (String)LOG_USERMANAGEMENT_UPDATE, (String)wsConfOCM.getWsEndpoint(), (String)wsConfOCM.getWsUser(), (String)wsConfOCM.getWsPwd(), (ExecutionTimerWrapper)etw);
    }

    public void serveResource(ResourceRequest request, ResourceResponse response) throws PortletException {
        block17: {
            HttpServletRequest servletRequest = PortalUtil.getHttpServletRequest((PortletRequest)request);
            try {
                HttpServletRequestWrapper wrapper = new HttpServletRequestWrapper(servletRequest){

                    public String getParameter(String name) {
                        if ("p_auth".equals(name)) {
                            return PortalUtil.getOriginalServletRequest((HttpServletRequest)((HttpServletRequest)super.getRequest())).getParameter(name);
                        }
                        return super.getParameter(name);
                    }
                };
                if ("GET".equalsIgnoreCase(servletRequest.getMethod())) {
                    SecurityUtils.noCacheResponse((ResourceResponse)response);
                } else {
                    AuthTokenUtil.checkCSRFToken((HttpServletRequest)wrapper, (String)((Object)((Object)this)).getClass().getName());
                }
            }
            catch (Exception e) {
                if (LOGGER.isErrorEnabled()) {
                    StringWriter sw = new StringWriter();
                    e.printStackTrace(new PrintWriter(sw));
                    LOGGER.error((Object)"Invalid CSRF validation!");
                    LOGGER.trace((Object)("Details: " + sw), (Throwable)e);
                }
                response.setProperty("portlet.http-status-code", Integer.toString(403));
                return;
            }
            String methodName = request.getResourceID();
            if (methodName != null) {
                try {
                    Method authorizeMethod = ((Object)((Object)this)).getClass().getMethod("authorizeRequest", String.class, ResourceRequest.class);
                    boolean authorized = (Boolean)authorizeMethod.invoke((Object)this, methodName, request);
                    if (authorized) {
                        Method method = ((Object)((Object)this)).getClass().getMethod(methodName, ResourceRequest.class, ResourceResponse.class);
                        method.invoke((Object)this, request, response);
                    } else {
                        response.setProperty("portlet.http-status-code", Integer.toString(404));
                        if (LOGGER.isErrorEnabled()) {
                            LOGGER.error((Object)"Authorization exception.");
                        }
                    }
                    break block17;
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    if (e instanceof InvocationTargetException) {
                        InvocationTargetException invocException = (InvocationTargetException)e;
                        if (invocException.getCause() instanceof InputValidationException) {
                            response.setProperty("portlet.http-status-code", Integer.toString(400));
                            if (LOGGER.isErrorEnabled()) {
                                LOGGER.error((Object)invocException.getCause().getMessage());
                            }
                        }
                    } else {
                        response.setProperty("portlet.http-status-code", Integer.toString(500));
                        if (LOGGER.isErrorEnabled()) {
                            LOGGER.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                    break block17;
                }
            }
            response.setProperty("portlet.http-status-code", Integer.toString(400));
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Invalid request, no resource specified.");
            }
        }
    }

    public void sendResponse(ResourceResponse response, Object object) {
        try {
            String json = "";
            if (object != null) {
                json = StringUtils.convertToGson((Object)object);
            }
            response.getWriter().write(HtmlUtil.toInputSafe((String)json));
            response.flushBuffer();
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public String getDataAjax(ResourceRequest resourceRequest, String param) {
        HttpServletRequest httpReq = PortalUtil.getHttpServletRequest((PortletRequest)resourceRequest);
        return PortalUtil.getOriginalServletRequest((HttpServletRequest)httpReq).getParameter(param);
    }
}

